/*
 * Hellenic Whitepages Reverse Lookup Widget
 * Javascript.
 * ©2007 cosmix.org
 *
 * MIT Licence. Attribution required in any derivatives of this work.
 * 
 * Version 1.05
 */

var gDoneButton;
var gInfoButton;
var req;
var xmlResult;
var name;
var address;
var wHeight, wWidth;


function convToUTF8(inputString) {

	var utf8Out= "";

	for (var x =0; x < inputString.length; x++)
	{
		var curCharCode = inputString.charCodeAt(x);
		
		if (curCharCode < 128)
		{
			utf8Out += String.fromCharCode(curCharCode);
		} 
		else
		{
			utf8Out += String.fromCharCode(curCharCode + 720);
		}
	}
	return utf8Out;
}


function loaded() 
{
	// setup buttons etc.
	gDoneButton = new AppleGlassButton(document.getElementById("doneButton"), "Done", hidePrefs);
	gInfoButton = new AppleInfoButton(document.getElementById("infoButton"), document.getElementById("front"), "white", "white", showPrefs);

	stretcher = new Stretcher(document.getElementById('wrapper'),140,293,animHandler);
}

function animHandler()
{
	return;
}

function hidePrefs()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
 
    if (window.widget)
        widget.prepareForTransition("ToFront");
 
    back.style.display="none";
    front.style.display="block";

 		document.getElementById('txtPhone').value = "";

    if (window.widget)
        setTimeout ('widget.performTransition();', 0);
				if (stretcher.isStretched()){
					stretcher.stretch(event);
				}
}

function showPrefs()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");


 		window.resizeTo(293,210); 
    if (window.widget)
        widget.prepareForTransition("ToBack");
 
    front.style.display="none";
    back.style.display="block";

    if (window.widget)
        setTimeout ('widget.performTransition();', 0);
}

function doSearch(event)
{
	inText = event.srcElement.value;

	if (inText != '' && inText != null)
	{
		myRE = /^2\d{9}$/;
		if (myRE.test(inText))
		{
			if (stretcher.isStretched())
			stretcher.stretch(event);
			loadResults(inText);
		} else {
			document.getElementById('lblLoading').innerHTML = "Not a hellenic phone Nº!";
			document.getElementById('lblLoading').style.display = "block";
		}
	} else {
		if (stretcher.isStretched())
		stretcher.stretch(event);
	}
}


function loadResults(phone)
{
	if (window.XMLHttpRequest)
	{
		req = new XMLHttpRequest();
		req.setRequestHeader("Referer", "http://www.whitepages.gr/gr/")
		req.onreadystatechange = handleData;
		req.open("POST",'http://www.whitepages.gr/gr/results.aspx',true);
		req.send("x_nomosid_search=&x_poli2=&x_surname=&x_fname=&x_pname=&x_tel="+phone+"&x_bigcity=%CE%91%CE%98%CE%97%CE%9D%CE%91&x_daslocality=&x_nomosid=&x_poli=&x_area=&x_das=&x_area_latin=&Image81.x=0&Image81.y=0");
		document.getElementById('lblLoading').innerHTML = "Searching...";
		document.getElementById('lblLoading').style.display = "block";
	} else {
		document.getElementById('lblLoading').innerHTML = "ERROR";
		document.getElementById('lblLoading').style.display = "block";
	}
}

function handleData()
{
	if (req && req.readyState == 4)
	{
		if (!(req.status) || req.status == 200) 
		{
			document.getElementById('lblLoading').style.display = "none";
			xmlResult = req.responseText;
			parsePhoneInfo();
			document.getElementById('txtName').innerHTML = name;
			document.getElementById('txtAddress').innerHTML = address;
			if (!stretcher.isStretched())
				stretcher.stretch(event);
		} else {
			document.getElementById('lblLoading').innerHTML = "ERROR";
			document.getElementById('lblLoading').style.display = "block";
		}
	} else if (req && req.readystate == 2)	{
		document.getElementById('lblLoading').style.display = "block";
		document.getElementById('lblLoading').innerHTML = "Wait..";
	}
}


function parsePhoneInfo()
{
	var tokenised = xmlResult.split('height="46"');
	nameRaw = tokenised[1];
	
	if (nameRaw != undefined)
	{
		//alert(nameRaw);
		myRE = /<b><span [^>]*>([^&]*)\&nbsp;([^&]*)\&nbsp;\S?<br><\/span><\/b>/;
		nameRA = myRE.exec(nameRaw);
		name = nameRA[1] + " " + nameRA[2];
	} else {
		name = "Not found.";
	}
	
	addressRaw = tokenised[2];
	if (addressRaw != undefined)
	{
		//alert('addressRaw: ' + addressRaw);
		//addressRaw2 = addressRaw.split('</div>');
		//alert(addressRaw2);
		
		// get borough
		myRE = /<div align="left">([^<]*)<br>/;
		addressBorough = myRE.exec(addressRaw);
		//alert('addressBorough: ' + addressBorough);
		
		// get address
		myRE = /<span id="reslist_ctl01_straddr" class="text-black">([^<]*)<\/span>/;
		addressStreet = myRE.exec(addressRaw);
		//alert(addressStreet);
		
		// get Postcode
		myRE = /<span id="reslist_ctl01_postal" class="text-black">([^<]*)<\/span>/;		
		addressPostal = myRE.exec(addressRaw);
		
		address = addressBorough[1] + "<br/>" + addressStreet[1] + "<br/>" + addressPostal[1];
//		myRE = /left">((.|\n)*)/gm;
//		addressRA = myRE.exec(addressRaw2[0]);
//		alert(addressRA[1]);
//		address = addressRA[1];

	} else {
		address = 'Not available';
	}
// 	address = "DefaultAddress";

}
